﻿using System;
using System.Threading;
using System.Windows;
using ISingleInstance = SingleInstanceCore.ISingleInstance;

namespace ANSURLProtocol_Sample
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application, ISingleInstance
    {
        /// <value>Gets the value of current MainWindow.</value>
        public MainWindow mainWindow;

        /// <summary>
        /// Specific SingleInstance callback calls by second instance when it has arguments.
        /// </summary>
        /// <param name="args">Arguments pass by second instance</param>
        public void OnInstanceInvoked(string[] args)
        {
            string userPath = args[1];

            mainWindow.Dispatcher.Invoke(new Action(() => mainWindow.Connection(userPath.Substring(userPath.IndexOf(":") + 1))));
        }

        /// <summary>
        /// Specific SingleInstance process to verify current is the first instance or not.
        /// </summary>
        private void Application_Startup(object sender, StartupEventArgs e)
        {
            bool isFirstInstance = SingleInstanceCore.SingleInstance<App>.InitializeAsFirstInstance("WpfApp1");
            if (!isFirstInstance)
            {
                // Let time to first instance receiving arguments from current
                // 10 seconds are arbitrary
                Thread.Sleep(10000);

                // Shutdown Current
                Current.Shutdown();
            }
            else
            {
                // Define mainWindow to invoke it on OnInstanceInvoked method
                mainWindow = this.MainWindow as MainWindow;
                mainWindow.Dispatcher.Invoke(new Action(() => mainWindow.AddURLProtocol()));
            }
        }

        /// <summary>
        /// Specific SingleInstance process use to clean all.
        /// </summary>
        private void Application_Exit(object sender, ExitEventArgs e)
        {
            mainWindow.Dispatcher.Invoke(new Action(() => mainWindow.RemoveURLProtocol()));
            // Do not forget to cleanup
            SingleInstanceCore.SingleInstance<App>.Cleanup();
        }
    }
}
