﻿using Microsoft.Win32;
using System;
using System.IO;
using System.Net;
using System.Text.Json;
using System.Windows;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;


namespace ANSURLProtocol_Sample
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public static RoutedCommand ConnectCommand = new RoutedCommand();
        public static RoutedCommand DisconnectCommand = new RoutedCommand();
        public static RoutedCommand CloseCommand = new RoutedCommand();
        public static RoutedCommand AddURLProtocoleCommand = new RoutedCommand();
        public static RoutedCommand RemoveURLProtocoleCommand = new RoutedCommand();

        /// <value>Gets the value of User informations.</value>
        public UserAccount userAccount;

        /// <summary>
        /// MainWindo constructor.
        /// Only add specific command binding for MenuItem.
        /// </summary>
        public MainWindow()
        {
            this.CommandBindings.Add(new CommandBinding(ConnectCommand, ExecutedConnectedCommand, CanExecuteConnectedCommand));
            this.CommandBindings.Add(new CommandBinding(DisconnectCommand, ExecutedDisconnectedCommand, CanExecuteDisconnectedCommand));
            this.CommandBindings.Add(new CommandBinding(CloseCommand, ExecutedCloseCommand, CanExecuteCloseCommand));
            this.CommandBindings.Add(new CommandBinding(AddURLProtocoleCommand, ExecutedAddURLProtocoleCommand, CanExecuteAddURLProtocoleCommand));
            this.CommandBindings.Add(new CommandBinding(RemoveURLProtocoleCommand, ExecutedRemoveURLProtocoleCommand, CanExecuteRemoveURLProtocoleCommand));

            InitializeComponent();
        }

        /// <summary>
        /// Open default browser using Authentication Server URL.
        /// </summary>
        private void ExecutedConnectedCommand(object sender, ExecutedRoutedEventArgs e)
        {
            string target = "https://psc-app.webinar.esante.gouv.fr";
            Informations.Text = "";

            try
            {
                System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo
                {
                    FileName = target,
                    UseShellExecute = true
                };
                System.Diagnostics.Process.Start(psi);
            }
            catch (System.ComponentModel.Win32Exception noBrowser)
            {
                if (noBrowser.ErrorCode == -2147467259)
                    MessageBox.Show(noBrowser.Message);
            }
            catch (System.Exception other)
            {
                MessageBox.Show(other.Message);
            }

            AddInformations("Ouverture du navigateur sur le serveur d'authentification");
            AddInformations("---------------------------------------------------------");

        }

        /// <summary>
        /// Disconnection process.
        /// </summary>
        private void ExecutedDisconnectedCommand(object sender, ExecutedRoutedEventArgs e)
        {
            Disconnection();
        }

        /// <summary>
        /// Exit process.
        /// </summary>
        private void ExecutedCloseCommand(object sender, ExecutedRoutedEventArgs e)
        {
            Application.Current.Shutdown();
        }

        /// <summary>
        /// Add specific URL Protocol in System Registry.
        /// </summary>
        public void AddURLProtocol()
        {
            RegistryKey ANSURLProtocol = Registry.CurrentUser.OpenSubKey("Software", true).OpenSubKey("Classes", true).CreateSubKey("ANSURLProtocol");

            ANSURLProtocol.SetValue("", "URL:ANSURLProtocol");
            ANSURLProtocol.SetValue("URL Protocol", "ANSURLProtocol");
            ANSURLProtocol.CreateSubKey("Shell\\Open\\command").SetValue("", Directory.GetCurrentDirectory() + "\\" + System.Reflection.Assembly.GetEntryAssembly().GetName().Name + ".exe %1");

            this.AddURLProtocolItem.IsEnabled = false;
            this.RemoveURLProtocolItem.IsEnabled = true;
        }

        /// <summary>
        /// Remove specific URL Protocol in System Registry.
        /// </summary>
        public void RemoveURLProtocol()
        {
            Registry.CurrentUser.OpenSubKey("Software", true).OpenSubKey("Classes", true).DeleteSubKey("ANSURLProtocol\\Shell\\Open\\command");
            Registry.CurrentUser.OpenSubKey("Software", true).OpenSubKey("Classes", true).DeleteSubKey("ANSURLProtocol\\Shell\\Open");
            Registry.CurrentUser.OpenSubKey("Software", true).OpenSubKey("Classes", true).DeleteSubKey("ANSURLProtocol\\Shell");
            Registry.CurrentUser.OpenSubKey("Software", true).OpenSubKey("Classes", true).DeleteSubKey("ANSURLProtocol");

            this.AddURLProtocolItem.IsEnabled = true;
            this.RemoveURLProtocolItem.IsEnabled = false;
        }

        private void ExecutedAddURLProtocoleCommand(object sender, ExecutedRoutedEventArgs e)
        {
            AddURLProtocol();
        }

        private void ExecutedRemoveURLProtocoleCommand(object sender, ExecutedRoutedEventArgs e)
        {
            RemoveURLProtocol();
        }

        private void CanExecuteConnectedCommand(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void CanExecuteDisconnectedCommand(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void CanExecuteCloseCommand(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void CanExecuteAddURLProtocoleCommand(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        private void CanExecuteRemoveURLProtocoleCommand(object sender, CanExecuteRoutedEventArgs e)
        {
            e.CanExecute = true;
        }

        /// <summary>
        /// Add some Text to Log view.
        /// </summary>
        public void AddInformations(string Text)
        {
            Informations.Inlines.Add(new Run(Text + Environment.NewLine));
        }

        /// <summary>
        /// Add some Text to Log view.
        /// </summary>
        public void AddUserInformations(UserAccount userAccount)
        {
            Informations.Inlines.Add(new Run("SubjectNameID : "));
            Informations.Inlines.Add(new Bold(new Run(userAccount.OIDCSubjectNameID + Environment.NewLine)));
            Informations.Inlines.Add(new Run("preferred_username : "));
            Informations.Inlines.Add(new Bold(new Run(userAccount.OIDCpreferred_username + Environment.NewLine)));
            Informations.Inlines.Add(new Run("given_name : "));
            Informations.Inlines.Add(new Bold(new Run(userAccount.OIDCgiven_name + Environment.NewLine)));
            Informations.Inlines.Add(new Run("family_name : "));
            Informations.Inlines.Add(new Bold(new Run(userAccount.OIDCfamily_name + Environment.NewLine)));
        }

        /// <summary>
        /// Callback invoked by Application parent process in URL Protocol process.
        /// </summary>
        /// <remarks>
        /// Use a specific Authentication Server URL which stores User infos data.
        /// </remarks>
        /// <param name="UserPath">Input Hash Path used to access User infos data by URL</param>
        public void Connection(string UserPath)
        {
            if (UserPath != "")
            {
                AddInformations("Récupération des informations utilisateurs");
                AddInformations("------------------------------------------");
                AddInformations("");
                AddInformations("URL Protocol : ANSURLProtocol:" + UserPath);
                AddInformations("");
                AddInformations("Get user infos : https://psc-app.webinar.esante.gouv.fr/data/" + UserPath);
                AddInformations("");
                using (WebClient wc = new WebClient())
                {
                    var json = wc.DownloadString("https://psc-app.webinar.esante.gouv.fr/data/" + UserPath);

                    userAccount = JsonSerializer.Deserialize<UserAccount>(json);
                    userAccount.URLPRotocolPath = UserPath;

                    AddInformations("User infos in JSON format : ");
                    AddInformations(json);
                    AddInformations("");
                    AddInformations("Expand User infos :");
                    AddUserInformations(userAccount);
                    AddInformations("");
                    UserInfos.Header = userAccount.OIDCfamily_name + " " + userAccount.OIDCgiven_name + " (" + userAccount.OIDCSubjectNameID + ")";
                    UserInfos.Foreground = new SolidColorBrush(Colors.Green);
                }
                Connect.IsEnabled = false;
                Disconnect.IsEnabled = true;
            }
        }

        /// <summary>
        /// Disconnection is donne by cleaning all user values.
        /// </summary>
        private void Disconnection()
        {
            AddInformations("Déconnexion locale");
            AddInformations("------------------");
            userAccount = null;
            Disconnect.IsEnabled = false;
            Connect.IsEnabled = true;
            UserInfos.Header = "Non Connecté";
            UserInfos.Foreground = new SolidColorBrush(Colors.Red);
        }
    }

    /// <summary>
    /// User class used to store all user informations.
    /// </summary>
    public class UserAccount
    {
        public string OIDCSubjectNameID { get; set; }
        public string OIDCpreferred_username { get; set; }
        public string OIDCgiven_name { get; set; }
        public string OIDCfamily_name { get; set; }
        public string URLPRotocolPath { get; set; }
    }
}
