<?php
date_default_timezone_set ( "Europe/Paris");

$prefix = 'OIDC';

if (array_key_exists($prefix . 'SubjectNameID', $_SERVER)) {
	
	$jsonData = array();
	$filename = hash( "sha256", $_SERVER[$prefix . 'SubjectNameID'] . date("YmdHis"));

	$OIDCs = '<div id="OIDCs">';
	foreach ($_SERVER as $OIDC_Key => $OIDC_Value) {
		if (strstr($OIDC_Key, $prefix)) {
			switch ($OIDC_Key) {
				case $prefix . "SubjectNameID":
				case $prefix . "preferred_username":
				case $prefix . "given_name":
				case $prefix . "family_name":
				case $prefix . "SubjectRefPro":
					$jsonData[$OIDC_Key] = $OIDC_Value;
					break;
			}
			
			$idJSON = '';
			if ($OIDC_Key == $prefix . 'SubjectRefPro') {
				$idJSON = ' id="jsonView"';
			}
			$OIDCs .= '<div class="tline"><div class="tcolumn ckey">' . $OIDC_Key . '</div><div class="tcolumn cvalue"' . $idJSON . '>' . $OIDC_Value . '</div></div>';
		}
	}
	$OIDCs .= '</div>';

	$section = '
		<center>
			<div class="validate"></div>
			<div class="success">BRAVO !</div><br/>
			Vous êtes connecté au BAC A SABLE. Vous allez être renvoyé sur votre application.
		</center>
		<br/>
		Infos du jeton<br/><div id="infos">' . $OIDCs . '</div>
		<div class="providers">
			<!--<div class="provider center_outer" onclick="location.href=\'/oidc/redirect?iss=https%3A%2F%2Fauth.bas.esw.esante.gouv.fr%2Fauth%2Frealms%2Fesante-wallet&logout=https://psc-app.webinar.esante.gouv.fr\'"><div>SE DECONNECTER</div></div>-->
			<div class="provider center_outer" onclick="logout(\'bas.\');"><div>SE DECONNECTER</div></div>
		</div>
	';
	
	file_put_contents( 'data/' . $filename, json_encode($jsonData, JSON_FORCE_OBJECT), FILE_APPEND);
}

include(dirname(__FILE__) . "/template.php");

?>
