<?php
$DEBUG = true;
header('Content-Type: text/html; charset=UTF-8');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Connexion sur ton application avec Pro Santé Connect</title>
	<meta http-equiv="Content-type" content="text/html; charset=UTF-8" />
	<meta name="description" content="Connexion sur ton application avec Pro Santé Connect." />
	<meta name="Publisher" content="ANS" />
	<meta name="copyright" content="Tous droits réservés - ANS" />
	<link rel="shortcut icon" href="./Asip_Sante_ANS_200x200-ConvertImage.ico" type="image/x-icon" />
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,500i&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="jsonview.css">
	<script src="jsonview.js"></script>
	<script type="text/javascript">
	function LaunchURLScript(parameter)
	{
		var url = "ANSURLProtocol:" + parameter;
		//window.open(url);
		//self.focus();
		document.getElementById("URLProtocol").src = url;
	}
	</script>
	<style>
	body {
		padding: 0 auto;
		margin: auto;
		width: 80vw;
		font-family: 'Roboto', sans-serif;
		font-style:italic;
	}
	#header {
		text-align: center;
	}
	#logo {
		margin: 2vh 0 2vh;
		height:3vh;
		background-size: contain;
		background-repeat: no-repeat;
		background-position: center;
		background-image: url('./LOGO_ANS_2020_Ligne.jpg');
	}
	#title {
		min-height: 7vh;
		font-size: 3vw;
		color:#706F6F;
		text-align: center;
	}
	.center_outer {
		display: flex;
		flex-wrap: wrap;
		justify-content: center;
		align-items: center;
	}
	.providers
	{
		display: flex;
		text-align:center;
		margin: auto;
	}
	.provider
	{
		float: left;
		width: 50vw;
		height: 5vh;
		background-color:#1B70B7;
		color:white;
		border-style: solid;
		border-color: white;
		border-width: 1vmin;
		text-align: center;
		margin: auto;
		font-size: 3vmin;
		padding: 1vmin;
	}
	.provider:hover {
		cursor:pointer;
	}
	.center {
		width: 50%;
		margin: 0 auto;
	}
	#section {
		min-height: 70vh;
		margin: auto;
		color: #706F6F;
		border: 1px solid #706F6F;
		padding: 1vmin;
		font-size: 2.5vmin;
		resize: vertical;
	}
	li {
		margin: 2vh;
	}
	.instruction {
		margin: 2vmin;
		font-style: normal;
	}
	.stores {
		height:6vh;
		display: flex;
	}
	.googleplay, .appstore {
		float: left;
		width: 30vw;
		height: 5vh;
		margin: 0.5vmin;
		background-size: contain;
		background-repeat: no-repeat;
		background-position: center;
	}
	.googleplay:hover, .appstore:hover {
		cursor: pointer;
	}
	.googleplay {
		background-image: url('./googleplay.png');
	}
	.appstore {
		background-image: url('./appstore.png');
	}
	.success {
		color: #D60951;
		font-size: 3vmin;
	}
	@keyframes toColor {
		0%    { -webkit-filter: grayscale(100%); filter: grayscale(100%); }
		100%  { -webkit-filter: grayscale(0%); filter: grayscale(0%); }
	}
	
	.validate {
		height: 20vh;
		width: 20vw;
		background-image: url('./Validate.png');
		background-size: contain;
		background-repeat: no-repeat;
		background-position: center;
		animation-timing-function: ease-in;
		animation: toColor 2s;
	}
	
	#OIDCs {
		display: flex;
		flex-wrap: wrap;
		justify-content: center;
		align-items: center;
		font-size: 1.2vw;
	}
	#infos {
		resize: vertical;
		height: 24vh;
		overflow: auto;
		border: 1px solid;
		background-color: #F5F5F0;
	}
	.tline {
		display: flex;
	}
	.tcolumn {
		width: 35vw;
	}
	.ckey {
		font-weight: bold;
		font-variant: small-caps;
		width: 20vw;
	}
	.cvalue {
		width: 50vw;
	}
	#URLProtocol {
		height: 0px;
		width: 0px;
	}
	</style>

<!--	<script src="./js/jquery-3.2.0.min.js"></script>
	<script src="./js/ua-parser.min.js"></script>-->
	<script type="text/javascript">
	function logout(environement) {
		chrome.cookies.remove({
				url: "wallet." + environement + "esw.esante.gouv.fr",
				name: "WALLET_ID"
			});
		  
		window.open('/oidc/redirect?session=logout');
	}
	</script>
</head>
<body>
<div id="header">
	<div id="logo" ></div>
	<div id="title" class="center_outer"><div>SE CONNECTEZ A VOTRE APPLICATION AVEC PRO SANTE CONNECT</div></div>
</div>
<div id="section">
<?php
	echo $section;
?>
</div>
<iframe id="URLProtocol" ></iframe>
<div id="footer">

</div>
</body>
</html>
<?php if (array_key_exists($prefix . 'SubjectNameID', $_SERVER)) { ?>
<script>
	if (document.getElementById('jsonView') != null)
	{
		let data = <?php echo '"' . $jsondata + '"'; ?>;
		let target = '#jsonView';
		document.getElementById('jsonView').innerHTML = "";
		jsonView.format(data, target);
	}
	
	LaunchURLScript(<?php echo '"' . $filename . '"'; ?>);
</script>
<?php } ?>